<?php
header('Content-Type: application/json');

$baseDir = 'mp3';
$requestedPath = isset($_GET['path']) ? $_GET['path'] : '';
$fullPath = $baseDir . '/' . $requestedPath;

// Security check - prevent directory traversal
if (strpos($requestedPath, '..') !== false || !is_dir($fullPath)) {
    echo json_encode(['folders' => [], 'files' => []]);
    exit;
}

$items = scandir($fullPath);
$result = [
    'folders' => [],
    'files' => []
];

foreach ($items as $item) {
    if ($item === '.' || $item === '..') continue;
    
    $itemPath = $fullPath . '/' . $item;
    
    if (is_dir($itemPath)) {
        $result['folders'][] = $item;
    } elseif (pathinfo($itemPath, PATHINFO_EXTENSION) === 'mp3') {
        $result['files'][] = $item;
    }
}

// Sort folders and files alphabetically
sort($result['folders']);
sort($result['files']);

echo json_encode($result);
?>